<?php



use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProposersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * 
     * @return void
     */
    public function up()
    {
        Schema::create('proposers', function (Blueprint $table) {
            $table->id();  // BIGINT AUTO_INCREMENT PRIMARY KEY
            $table->string('full_name');  // Full name
            $table->string('city_region')->nullable();
            $table->string('woreda')->nullable();
            $table->string('house_no')->nullable();
            $table->string('kebele')->nullable();
            $table->string('fixed_phone', 20)->nullable();
            $table->string('mobile_phone', 20)->nullable();
            $table->string('email')->nullable();
            $table->text('postal_address')->nullable();
            $table->foreignId('customer_id')->nullable()->constrained('customers')->onDelete('set null');  // Links to customers table
            $table->timestamps();  // created_at, updated_at
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('proposers');
    }
}
